﻿param (
    [Parameter(Mandatory=$true)][string]$samaccountname,
    [Parameter(Mandatory=$true)][string]$ou,
    [Parameter(Mandatory=$true)][string]$uitdienstou,
    [Parameter(Mandatory=$true)][string]$empnr,
    [Parameter(Mandatory=$true)][string]$userid
)

try{
    Get-ADUser -Filter "EmployeeNumber -eq '$empnr' -or UserPrincipalName -like '$userid@*' -or SamAccountName -eq '$samaccountname'" -SearchBase $ou |
    % {Move-ADObject $_ -TargetPath $uitdienstou}
    
    }
    catch{
        Write-Host "Fout bij het verplaatsen van de gebruiker"
    }